mkdir -p ppc && ( cd ppc
g++ -c -O3 -arch ppc -fPIC -dynamic -fno-common -DQMC -DMI_MODULE= -DMI_PRODUCT_RAY -DMACOSX -D_REENTRANT -I.. -I.. ../th_domeAFL_FOV.cpp
g++ -c -O3 -arch ppc -fPIC -dynamic -fno-common -DQMC -DMI_MODULE= -DMI_PRODUCT_RAY -DMACOSX -D_REENTRANT -I.. -I.. ../th_domeAFL_WxH.cpp
g++ -arch ppc -flat_namespace -undefined suppress -dynamiclib -o th_domeAFL.so th_domeAFL_FOV.o th_domeAFL_WxH.o
)

mkdir -p i386 && ( cd i386
g++ -c -O3 -mtune=pentiumpro -fexpensive-optimizations -fforce-mem -finline-functions -funroll-loops -fomit-frame-pointer -frerun-cse-after-loop -fstrength-reduce -fforce-addr -fPIC -std=c++98 -dynamic -m32 -fno-common -DQMC -DMI_MODULE= -DMI_PRODUCT_RAY -DMACOSX -D_REENTRANT -DEVIL_ENDIAN -DX86 -DHYPERTHREAD -I.. -I.. ../th_domeAFL_FOV.cpp
g++ -c -O3 -mtune=pentiumpro -fexpensive-optimizations -fforce-mem -finline-functions -funroll-loops -fomit-frame-pointer -frerun-cse-after-loop -fstrength-reduce -fforce-addr -fPIC -std=c++98 -dynamic -m32 -fno-common -DQMC -DMI_MODULE= -DMI_PRODUCT_RAY -DMACOSX -D_REENTRANT -DEVIL_ENDIAN -DX86 -DHYPERTHREAD -I.. -I.. ../th_domeAFL_WxH.cpp
g++ -flat_namespace -m32 -DX86 -undefined suppress -dynamiclib -o th_domeAFL.so th_domeAFL_FOV.o th_domeAFL_WxH.o
)

mkdir -p i386x64 && ( cd i386x64
g++-4.0 -c -O3 -fexpensive-optimizations -finline-functions -funroll-loops -fomit-frame-pointer -frerun-cse-after-loop -fstrength-reduce -fforce-addr -fPIC -std=c++98 -dynamic -fno-common -m64 -DQMC -DMI_MODULE= -DMI_PRODUCT_RAY -DMACOSX -D_REENTRANT -DEVIL_ENDIAN -DX86 -DHYPERTHREAD -DBIT64 -I.. -I..  ../th_domeAFL_FOV.cpp
g++-4.0 -c -O3 -fexpensive-optimizations -finline-functions -funroll-loops -fomit-frame-pointer -frerun-cse-after-loop -fstrength-reduce -fforce-addr -fPIC -std=c++98 -dynamic -fno-common -m64 -DQMC -DMI_MODULE= -DMI_PRODUCT_RAY -DMACOSX -D_REENTRANT -DEVIL_ENDIAN -DX86 -DHYPERTHREAD -DBIT64 -I.. -I..  ../th_domeAFL_WxH.cpp
g++-4.0 -flat_namespace -m64 -DX86 -undefined suppress -dynamiclib -o th_domeAFL.so th_domeAFL_FOV.o th_domeAFL_WxH.o
)

mkdir -p universal-plus-64
lipo -output universal-plus-64/th_domeAFL.so -create ppc/th_domeAFL.so i386/th_domeAFL.so i386x64/th_domeAFL.so
